import sale.*;
import data.*;
import data.ooimpl.*;
import data.events.*;
import users.*;


/**
 * Ein registrierter Kunde mitsamt seinem Videobestand.
 */
public class Customer extends User
{

  //// attributes ////////////////////////////////////////////////////////////

  private String       customerID;                // Kundennummer
  private StoringStock customerStoringStock;      // ausgeliehene Videos


  //// constructor ///////////////////////////////////////////////////////////

  /**
   * Legt einen neuen Kunden an.
   */
  public Customer(String customerID)
  {
    super(customerID);

    this.customerID = customerID;
    customerStoringStock = new StoringStockImpl(customerID,
      (CatalogImpl)Shop.getTheShop().getCatalog("Video-Catalog"));
    Shop.getTheShop().addStock(customerStoringStock);
  }


  //// public methods ////////////////////////////////////////////////////////

  /**
   * Liefert die Kunden-ID.
   */
  public String getCustomerID()
  {
    return customerID;
  }

  /**
   * F&uuml;gt die Kassette dem Bestand des Kunden hinzu.
   */
  public void addVideoCassette(CassetteStoringStockItem cassette)
  {
    customerStoringStock.add(cassette, null);
  }

  /**
   * L&ouml;scht die Kassette aus dem Bestand des Kunden.
   */
  public void removeVideoCassette(CassetteStoringStockItem cassette)
  {
    try {
      customerStoringStock.remove(cassette, null);
    }
    catch(VetoException ve) {
    }
  }

  /**
   * Liefert den gesamten Videobestand des Kunden.
   */
  public StoringStock getStoringStock()
  {
    return customerStoringStock;
  }

} 
