import sale.*;
import data.ooimpl.*;
import data.stdforms.*;


/**
 * Erzeugt eine Tabelle, sowie notwendige Buttons f&uuml;r die
 * Angebotsanzeige.
 */
public class DefaultCounterFormCreator extends FormSheetContentCreator
{

  //// constructor ///////////////////////////////////////////////////////////

  /**
   * Konstruktor.
   */
  public DefaultCounterFormCreator()
  {
    super();
  }


  //// public methods ///////////////////////////////////////////////////////


  /**
   * Erzeugt den <CODE>FormSheetContent</CODE>, also Tabelle(n) und
   * Buttons. Als Parameter wird das zu bearbeitende <CODE>FormSheet</CODE>
   * &uuml;bergeben.
   */
  public void createFormSheetContent(FormSheet map)
  {

    // heraussuchen des Videobestandes zur Darstellung in der Tabelle
    CountingStockImpl cs =
      (CountingStockImpl)Shop.getTheShop().getStock("Video-Countingstock");

    // erstellen des FormSheets mit der Tabelle des Bestandes als Inhalt
    FormSheet fs = SingleTableFormSheet.create("Available Videocassettes",
      cs, null, new OfferTED(false));

    // die Tabelle holen und dem uebergebenen FormSheet als Komponente zuweisen
    map.setComponent(fs.getComponent());
  
    // alle Buttons entfernen
    map.removeAllButtons();

    map.addButton ("rent", 1,
      new sale.Action()
      {
        public void doAction(SaleProcess p, SalesPoint s)
        {
          // Code zum Ausfuehren des Verleihvorgangs
          s.runProcess(new RentProcess());
        }
      }
    );

    map.addButton ("give back", 2,
      new sale.Action()
      {
        public void doAction(SaleProcess p, SalesPoint s)
        {
	  //Code zum Ausfuehren des Rueckgabevorgangs
	  s.runProcess(new GiveBackProcess());
        }
      }
    );
  }
}
