import data.*;
import sale.*;

import javax.swing.*;

/**
 * FormSheetContentCreator, der den Inhalt der Standard-FormSheets von
 * Office erzeugt
 */
class DefaultOfficeFormCreator extends FormSheetContentCreator
{

  //// attributes ////////////////////////////////////////////////////////////

  private Office officeOwner;


  //// constructor ///////////////////////////////////////////////////////////

  /**
   * Konstruktor. Erzeugt ein neues Objekt vom Typ
   * <CODE>DefaultOfficeFormCreator</CODE>.
   */
  public DefaultOfficeFormCreator(Office officeOwner)
  {
    super();
    this.officeOwner = officeOwner;
  }


  //// public methods ///////////////////////////////////////////////////////

  /**
   * Erzeugt den Inhalt des &uuml;bergebenen FormSheets.
   */
  public void createFormSheetContent (FormSheet fsToCreate)
  {
    // JPanel erzeugen und vertikales BoxLayout setzen
    JPanel jpFSComponent = new JPanel();
    
    jpFSComponent.setLayout (new BoxLayout (jpFSComponent, BoxLayout.Y_AXIS));
    
    // Label mit der aktuellen Zeit ins JPanel einfuegen
    jpFSComponent.add(new JLabel("Turn : " +
      Shop.getTheShop().getTimer().getTime()));

    // Geldbestand holen
    Stock coinSlot = Shop.getTheShop().getStock("coin slot");

    // DataBasket des Managers holen
    DataBasket db = officeOwner.getBasket();

    // verwendete Waehrung holen
    Currency currency = (Currency)Shop.getTheShop().getCatalog("DM");

    // Geldbestand aufsummieren und Label mit der Summe ins JPanel einfuegen
    IntegerValue money = (IntegerValue)coinSlot.sumStock(db,
      new CatalogItemValue(), new IntegerValue (0));

    jpFSComponent.add (new JLabel("Money : " + currency.toString(money)));

    // Komponente ins FormSheet einfuegen
    fsToCreate.setComponent (jpFSComponent);

    // Alle vorhandenen Buttons entfernen
    fsToCreate.removeAllButtons();

     // Button zum Schliessen eibauen
    fsToCreate.addButton ("Close", 1, new sale.Action() {
      public void doAction (SaleProcess p, SalesPoint sp) {
        officeOwner.quit();
      }
    });

  }
}
