import data.*;
import data.swing.*;

import sale.*;


/**
 * Ein TableEntryDescriptor zur Darstellung des Videoangebotes.
 */
public class OfferTED extends DefaultMoneyBagItemTED
{

  //// attributes ///////////////////////////////////////////////////////////

  private boolean withCount;  // Spalte fuer Anzahl mit anzeigen?


  //// constructor ///////////////////////////////////////////////////////////

  /**
   * Konstruktor. Erzeugt einen neues Objekt vom Typ OfferTED.
   */
  public OfferTED(boolean withCount)
  {
    super((Currency)Shop.getTheShop().getCatalog("DM"));
    this.withCount = withCount;
  }
  

 //// public methods ///////////////////////////////////////////////////////

 /**
   * Gibt die Spaltenanzahl der Tabelle zur&uuml;ck.
   */
  public int getColumnCount()
  {
    return withCount?3:2;
  }
  
  /**
   * Gibt die &Uuml;berschrift einer Spalte zur&uuml;ck.
   */
  public String getColumnName(int nIndex)
  {
    return (new String[] {"Name", "Price", "Available"}) [nIndex];
  }
  
  /**
   * Gibt den Wert einer Tabellenzelle zur&uuml;ck.
   */
  public Object getValueAt(Object oRecord, int nIndex)
  {
    // wenn Preis angefordert...
    if (nIndex == 1) {
      // die videokassette ermitteln
      VideoCassette vidCassette = (VideoCassette)(
        (CountingStockTableModel.Record)oRecord).getDescriptor();
      
      // den Verkaufspreis ermitteln und zurueckgeben
      return ((QuoteValue)vidCassette.getValue()).getBid();
    }
    else return super.getValueAt(oRecord, nIndex);
  }
}
