import sale.*;
import sale.events.*;
import sale.stdforms.*;
import data.events.*;
import data.ooimpl.*;
import log.*;
import log.stdforms.*;

import java.io.*;


/**
 * Diese Klasse implementiert das B&uuml;ro. Hier kann der Manager das
 * Logfile einsehen und Videos nachkaufen oder aus dem Bestand nehmen.
 */
public class Office extends SalesPoint
{
  //// attributes ////////////////////////////////////////////////////////////

  // Managerpasswort
  private static String password;


  //// constructor ///////////////////////////////////////////////////////////

  /**
   * Konstuktor erzeugt ein neues Objekt der Klasse <CODE>Office</CODE>.
   */
  public Office(String name)
  {
    super(name);

    // neuen StockChangeListener am Geldbestand des Automaten anmelden
    ((MoneyBagImpl)Shop.getTheShop().getStock
     ("coin slot")).addStockChangeListener(new StockChangeAdapter()
     {
       // StockItem wurde hinzugefuegt
       public void commitAddStockItems (StockChangeEvent sce)
       {
	 // hat sich der Geldbestand geaendert, FormSheet neu darstellen
	 if (getCurrentProcess() == null && hasUseableDisplay (null))
	   try {
	     setFormSheet (null, getDefaultFormSheet());
	   }
	   catch (InterruptedException iexc) {
	     System.err.println ("Update interrupted");
	   }
       }

       // StockItem wurde geloescht
       public void commitRemoveStockItems (StockChangeEvent sce)
       {
	 // hat sich der Geldbestand geaendert, FormSheet neu darstellen
	 if (getCurrentProcess() == null && hasUseableDisplay (null))
	   try {
	     setFormSheet (null, getDefaultFormSheet());
	   }
	   catch (InterruptedException iexc) {
	     System.err.println ("Update interrupted");
	   }
       }
     });

    // neuen TimerListener am Timer des Automaten anmelden
    Shop.getTheShop().getTimer().addTimerListener(new TimerAdapter()
    {
      public void onGoneAhead (TimerEvent trEvt)
      {
	// wurde Zeit weitergeschalten, FormSheet neu darstellen
	if (hasUseableDisplay(null)) {
	  try {
	    setFormSheet(null, getDefaultFormSheet());
	  }
	  catch (InterruptedException ie) {}
	}
      }
    });
  }


  //// public methods ///////////////////////////////////////////////////////

  /**
   * Gibt das Standard-FormSheet fr das B&uuml;ro zur&uuml;ck.
   */
  public FormSheet getDefaultFormSheet()
  {
    return new FormSheet("Office", new DefaultOfficeFormCreator(this), false);
  }

  /**
    * Gibt das Standard-MenuSheet zurck.
    */
  public MenuSheet getDefaultMenuSheet()
  {
    // neues Menue anlegen, wird Wartungsmenue
    MenuSheet msSubMenu = new MenuSheet("Maintenance");

    // neuen Menuepunkt zum Weiterschalten der Zeit anlegen
    msSubMenu.add(new MenuSheetItem ("Advance time", new sale.Action()
    {
      public void doAction(SaleProcess p, SalesPoint sp)
      {
        // Zeit weiterschalten
	Shop.getTheShop().getTimer().goAhead();
      }
    }));

    // neuen Menuepunkt zum Einsehen der Log-Datei anlegen
    msSubMenu.add (new MenuSheetItem ("See log file", new sale.Action()
    {
      public void doAction (SaleProcess p, SalesPoint sp)
      {
	try {
	  // LogTableForm erzeugen
	  FileInputStream fis = new FileInputStream ("machine.log");
	  LogInputStream lis = new LogInputStream (fis);
	  LogTableForm ltf = new LogTableForm ("View log file", lis);

	  // "Cancel"-Button entfernen
	  ltf.removeButton (FormSheet.BTNID_CANCEL);

	  // FormSheet setzen
	  setFormSheet (null, ltf);
	}

	// falls Datei nicht existiert
	catch (FileNotFoundException fnfexc) {
	  try {
	    setFormSheet(null, new MsgForm("Error", "Log file not found."));
	  }
	  catch (InterruptedException iexc) {}
	}

	// falls Fehler beim Lesen der Datei
	catch (IOException ioexc) {
	  try {
	    setFormSheet(null, new MsgForm("Error",
	      "Log file corrupt. It might be empty."));
	  }
	  catch (InterruptedException iexc) {}
	}

	// falls Setzen des FormSheets unterbrochen
	catch (InterruptedException iexc) {
	  try {
	    setFormSheet (null, new MsgForm ("Error", iexc.toString()));
	  }
	  catch (InterruptedException iexc2) {}
	}
      }
    }));

    // neues Menue anlegen, wird Menueleiste
    MenuSheet msMenu = new MenuSheet("office menu");

    // Wartungsmenue in Menueleiste des Bueros einbauen
    msMenu.add(msSubMenu);

    // Menleiste zurckgeben
    return msMenu;
  }



  /**
   * Setzt das Managerpasswort.
   */
  public static void setPassword(String password)
  {
    Office.password = password;
  }


  /**
   * Testet ob das &uuml;bergebene Passwort das Managerpasswort ist.
   */
  public static boolean testPassword(String password)
  {
    return password.equals(Office.password);
  }

}
