import sale.*;
import log.*;
import users.*;
import data.*;
import data.ooimpl.*;

import java.io.*;
import java.util.*;
import java.lang.*;

import javax.swing.*;


/**
 * Diese Klasse ist der "Shop" der Anwendung. Sie stellt das Grundger&uuml;st
 * f&uuml;r die Anwendung dar.
 */
public class VideoMachine extends Shop
{

  //// attributes ////////////////////////////////////////////////////////////

  // Liste aller registrierten Kunden
  private static Set customerSet = new HashSet();


  //// constructor ///////////////////////////////////////////////////////////

  /**
   * Konstruktor. Erzeugt ein neues Objekt vom Typ VideoAutomat.
   */
  public VideoMachine()
  {
    super();

    // Name und Preis fuer die Standart-Katalogeintraege
    String[] videos = {"Video 01", "Video 02", "Video 03", "Video 04",
                       "Video 05", "Video 06", "Video 07", "Video 08",
                       "Video 09", "Video 10"};
    int[] buy  = {5000, 5000, 5000, 5000, 5000, 4000, 4000, 4000, 3000, 3000};
    int[] sell = {4000, 4000, 4000, 4000, 3500, 3500, 3500, 3500, 3000, 3000};


    // Eintragung in den Catalog und den Stock
    Catalog videoCatalog = new CatalogImpl("Video-Catalog");
    addCatalog(videoCatalog);

    for (int i = 0; i < videos.length; i++) {
      videoCatalog.add(new VideoCassette (videos[i], new QuoteValue
        (new IntegerValue (buy[i]), new IntegerValue (sell[i]))), null);
    }

    CountingStock cs = new CountingStockImpl("Video-Countingstock",
      (CatalogImpl)videoCatalog);
    addStock(cs);

    // Erstellen eines Bestands von je 5 Videos (sollte spaeter
    // vom Manager uebernommen werden
    Iterator cassettes = videoCatalog.keySet(null).iterator();
    while (cassettes.hasNext()) {
      cs.add((String)cassettes.next(), 5, null);
    }

    // Anlegen einer Waehrung und Erstellen eines dazugehoerigen
    // Geldbestandes
    addCatalog(new CurrencyImpl("DM"));

    MoneyBag coinSlot = new MoneyBagImpl("coin slot",
      (CurrencyImpl)getCatalog("DM"));
    coinSlot.add("1-Pfennig-Stueck", 100000, null);
    addStock(coinSlot);
  }


  //// public methods ///////////////////////////////////////////////////////

  /**
   * Die Main-Methode startet die Anwendung.
   */
  public static void main (String[] args)
  {
    // neuen Videoautomaten erzeugen
    VideoMachine vidMachine = new VideoMachine();
    setTheShop(vidMachine);

    // Log umdefinieren...
    //    Log.setLogCreator(new MyLogCreator());

    // Datei zuweisen, in die das Log geschrieben werden soll
    try {
      Log.setGlobalOutputStream(new FileOutputStream("machine.log", true));
    }
    catch (IOException ioex) {
      System.err.println("Unable to create log file.");
    }

    // Verleih bzw. Kasse anlegen
    Counter c = new Counter("Video Rental");
    c.attach(new DataBasketImpl());
    c.attach(new User("SalespointUser"));
    vidMachine.addSalesPoint(c);

    // Anlegen des Manager-Passworts
    // Pawortfelder erzeugen
    JPasswordField jPasswordField1 = new JPasswordField();
    JPasswordField jPasswordField2 = new JPasswordField();

    // neues JPanel anlegen und vertikales Boxlayout setzen
    JPanel jPasswordRequest = new JPanel();
    jPasswordRequest.setLayout(new BoxLayout(jPasswordRequest,
					     BoxLayout.Y_AXIS));

    // Label und Pawortfelder einfuegen
    jPasswordRequest.add(new JLabel("Enter the manger's password:"));
    jPasswordRequest.add(jPasswordField1);
    jPasswordRequest.add(new JLabel("Re-enter the manager's password:"));
    jPasswordRequest.add(jPasswordField2);

    // Pawortabfrage wiederholen bis Uebereinstimmung zwischen den Worten
    do {
      JOptionPane.showMessageDialog (null,
				     jPasswordRequest,
				     "Manager",
				     JOptionPane.QUESTION_MESSAGE);
    } while (!new String(jPasswordField1.getPassword()).equals(
        new String(jPasswordField2.getPassword())));

    // Managerpasswort setzen
    Office.setPassword(new String(jPasswordField1.getPassword()));

    // Titel setzen und starten
    vidMachine.setShopFrameTitle("Videoverleihautomat *** HOMECINEMA *** 24h");
    vidMachine.start();

    vidMachine.getShopFrame().setSize(640,480);
    vidMachine.getShopFrame().validate();
  }


  /**
   * Erzeugt die Menueleiste des Hauptfensters unseres Automatens.
   */
  public MenuSheet createShopMenuSheet()
  {
    // urspruengliche Menueleiste erzeugen und abspeichern
    MenuSheet msMenuBar = super.createShopMenuSheet();

    // 'Shop'-Menue heraussuchen lassen
    MenuSheet msShopMenu =
      (MenuSheet)msMenuBar.getTaggedItem (SHOP_MENU_TAG, true);

    // nach unten zu schiebende Menuepunkte zunaechst aus dem
    // Menue loeschen, aber in lokalen Variablen speichern
    MenuSheetItem msLoadItem = (MenuSheetItem)msShopMenu.remove(LOAD_TAG);
    MenuSheetItem msSaveItem = (MenuSheetItem)msShopMenu.remove(SAVE_TAG);
    MenuSheetSeparator msSeparator =
      (MenuSheetSeparator)msShopMenu.remove(SEPARATOR_TWO_TAG);
    MenuSheetItem msQuitItem = (MenuSheetItem)msShopMenu.remove(QUIT_SHOP_TAG);

    MenuSheetItem msManagerItem = new MenuSheetItem("Open Office",
      new sale.Action()
      {
	public void doAction (SaleProcess p, SalesPoint sp)
	{
	  List l = getSalesPoints();
	  for (int i = 0; i < l.size(); i++) {
	    if (((SalesPoint)l.get(i)).getName() == "Office") {
	      javax.swing.JOptionPane.showMessageDialog(null,
		"There is an already an Office",
		"Error",
		javax.swing.JOptionPane.ERROR_MESSAGE);
	      return;
	    }
	  }
        
	  // Pawortfeld erzeugen
	  JPasswordField jPasswordField = new JPasswordField();

	  // neues JPanel anlegen und vertikales Boxlayout setzen
	  JPanel jPasswordRequest = new JPanel();
	  jPasswordRequest.setLayout(new BoxLayout(jPasswordRequest,
						   BoxLayout.Y_AXIS));
         
	  // Label und Passwortfelder einfuegen
	  jPasswordRequest.add(new JLabel("Enter the manger's password:"));
	  jPasswordRequest.add(jPasswordField);

	  // Passwortabfrage
	  JOptionPane.showMessageDialog (null,
					 jPasswordRequest,
					 "Manager",
					 JOptionPane.QUESTION_MESSAGE);

	  // ist eingegebenes Passwort korrekt?
	  if (Office.testPassword(new String(jPasswordField.getPassword()))) {

	    // ja -> Buero anlegen
	    Office o = new Office("Office");
	    o.attach (new DataBasketImpl());
	    o.attach (new User("Manager"));
	    Shop.getTheShop().addSalesPoint (o);
	  }

	  // nein -> Info an Nutzer
	  else {
	    JOptionPane.showMessageDialog(null,
                "Access denied!");
	  }
	}
	});

    // Menueeintraege in der gewuenschten Reihenfolge wieder einfuegen
    msShopMenu.add (msManagerItem);
    msShopMenu.add (msSeparator);
    msShopMenu.add (msLoadItem);
    msShopMenu.add (msSaveItem);
    msShopMenu.add (msSeparator);
    msShopMenu.add (msQuitItem);

    // Menueleiste zurueckgeben
    return msMenuBar;
  }


  /**
    * Beendet das Programm ohne den Stand abzuspeichern.
    */
  public void quit()
  {
    if (Shop.getTheShop().shutdown (false)) {
      System.exit (0);
    }
  }

  /**
   * F&uuml;gt der Liste registrierter Kunden einen neuen hinzu.
   */
  public static void addCustomer(Customer customer)
  {
    customerSet.add(customer);
  }

  /**
   * L&ouml;scht den angegebenen Kunden aus der Liste registrierter
   * Kunden heraus.
   */
  public static void removeCustomer(Customer customer)
  {
    customerSet.remove(customer);
  }

  /**
   * Liefert eine Liste aller registrierter Kunden.
   */
  public static Set getAllCustomer()
  {
    return customerSet.isEmpty() ? null : customerSet;
  }


  /**
   * Liefert das Kundenobject zur &uuml;bergebenen Kundennummer.
   */
  public static Customer getCustomerByID(String customerID)
  {
    Iterator i = customerSet.iterator();
    while (i.hasNext()) {
      Customer customer = (Customer)i.next();
      if (customer.getCustomerID().equals(customerID))
	return customer;
    }
    return null;
  }
}
